-- BGA_FilltypeExtension.lua
-- Autor: Tidde23


local BGA = rawget(_G, "g_bgaAddFermented") or {}
if BGA._initialized then return end
_G.g_bgaAddFermented = BGA
BGA._initialized = true


BGA.attachBaseFillType = "SILAGE"

-- Konversionskonfiguration: incoming -> outgoing (immer SILAGE) + ratio
BGA.extraFillTypesConfig = {
    { name = "CHOPPEDMAIZE_FERMENTED", ratio = 1.10 },
    { name = "GRASS_FERMENTED",        ratio = 0.95 },
    { name = "ALFALFA_FERMENTED",      ratio = 0.83 },
    { name = "CLOVER_FERMENTED",       ratio = 0.90 },

    { name = "GRASS_WINDROW",          ratio = 0.49 },
    { name = "ALFALFA_WINDROW",        ratio = 0.42 },
    { name = "CLOVER_WINDROW",         ratio = 0.41 },
}

BGA.filteredExtras = nil  -- wird in loadMap gefüllt

local function ftIndex(name)
    if not name or name == "" then return nil end
    return g_fillTypeManager:getFillTypeIndexByName(string.upper(name))
end

local function splitStr(str)
    if not str or str == "" then return {} end
    return string.split(str, " ")
end

local function hasToken(str, token)
    if not str or str == "" then return false end
    token = token:upper()
    for _, part in ipairs(splitStr(str)) do
        if part:upper() == token then
            return true
        end
    end
    return false
end

local function appendUniqueTokens(str, names)
    local existing = {}
    for _, part in ipairs(splitStr(str)) do
        existing[part:upper()] = true
    end
    for _, n in ipairs(names) do
        local up = n:upper()
        if not existing[up] then
            str = (str == "" or str == nil) and up or (str .. " " .. up)
            existing[up] = true
        end
    end
    return str
end

function BGA:loadMap(_)
    local baseIdx = ftIndex(self.attachBaseFillType)
    if not baseIdx then
        self.filteredExtras = {}
        return
    end

    local filtered = {}
    for _, cfg in ipairs(self.extraFillTypesConfig) do
        local idx = ftIndex(cfg.name)
        if idx ~= nil then
            filtered[#filtered+1] = {
                name  = cfg.name:upper(),
                ratio = cfg.ratio or 1.0
            }
        end
    end
    self.filteredExtras = filtered
end
addModEventListener(BGA)

local function isBiogasProduction(xmlFile, key)
    local isBGA = false
    xmlFile:iterate(key .. ".productions.production", function(_, prodKey)
        xmlFile:iterate(prodKey .. ".outputs.output", function(_, outKey)
            local ftName = (xmlFile:getValue(outKey .. "#fillType", "") or ""):upper()
            if ftName == "METHANE" or ftName == "DIGESTATE" then
                isBGA = true
            end
        end)
    end)
    return isBGA
end

local function hasConversion(xmlFile, unloadKey, incomingName, outgoingName)
    local found = false
    xmlFile:iterate(unloadKey .. ".fillTypeConversion", function(_, convKey)
        local inName  = (xmlFile:getValue(convKey .. "#incomingFillType") or ""):upper()
        local outName = (xmlFile:getValue(convKey .. "#outgoingFillType") or ""):upper()
        if inName == incomingName:upper() and outName == outgoingName:upper() then
            found = true
        end
    end)
    return found
end

local function addConversionsForExtras(xmlFile, unloadKey, baseName, extras)
    local lastIdx = -1
    xmlFile:iterate(unloadKey .. ".fillTypeConversion", function(i, _)
        if i > lastIdx then lastIdx = i end
    end)

    for _, cfg in ipairs(extras or {}) do
        local incoming = cfg.name
        if not hasConversion(xmlFile, unloadKey, incoming, baseName) then
            lastIdx = lastIdx + 1
            local cKey = string.format("%s.fillTypeConversion(%d)", unloadKey, lastIdx)
            xmlFile:setValue(cKey .. "#incomingFillType", incoming)
            xmlFile:setValue(cKey .. "#outgoingFillType", baseName:upper())
            xmlFile:setValue(cKey .. "#ratio", cfg.ratio or 1.0)
        end
    end
end

local function extendBaleTriggers(xmlFile, baseKey, baseFillType, extras)
    xmlFile:iterate(baseKey .. ".sellingStation.baleTrigger", function(_, baleKey)
        local ftStr = xmlFile:getString(baleKey .. "#fillTypes")
        if ftStr ~= nil and hasToken(ftStr, baseFillType) then
            local toAdd = {}
            for _, cfg in ipairs(extras or {}) do
                toAdd[#toAdd+1] = cfg.name
            end
            local newStr = appendUniqueTokens(ftStr, toAdd)
            xmlFile:setString(baleKey .. "#fillTypes", newStr)
        end
    end)
end

local function onLoadProductionPoint(self, superFunc, components, xmlFile, key, customEnv, i3dMappings)
    if not BGA.filteredExtras or #BGA.filteredExtras == 0 then
        return superFunc(self, components, xmlFile, key, customEnv, i3dMappings)
    end

    if not isBiogasProduction(xmlFile, key) then
        return superFunc(self, components, xmlFile, key, customEnv, i3dMappings)
    end

    local baseName = BGA.attachBaseFillType

    xmlFile:iterate(key .. ".sellingStation.unloadTrigger", function(_, unloadKey)
        local ftStr = xmlFile:getString(unloadKey .. "#fillTypes")
        if ftStr == nil or ftStr == "" then
            return
        end

        if not hasToken(ftStr, baseName) then
            return
        end

        local toAdd = {}
        for _, cfg in ipairs(BGA.filteredExtras) do
            toAdd[#toAdd+1] = cfg.name
        end
        local newStr = appendUniqueTokens(ftStr, toAdd)
        xmlFile:setString(unloadKey .. "#fillTypes", newStr)

        addConversionsForExtras(xmlFile, unloadKey, baseName, BGA.filteredExtras)
    end)

    extendBaleTriggers(xmlFile, key, baseName, BGA.filteredExtras)

    local ret = superFunc(self, components, xmlFile, key, customEnv, i3dMappings)
    return ret
end

ProductionPoint.load = Utils.overwrittenFunction(ProductionPoint.load, onLoadProductionPoint)
