-- FeedingRobot_Extension
-- Version: 1.0.0.0
-- Author: Tidde23

local FRConv = rawget(_G, "g_feedingRobotExtension") or {}
if FRConv._initialized then return end
_G.g_feedingRobotExtension = FRConv
FRConv._initialized = true

FRConv.config = {
    SILAGE = "GRASS_FERMENTED ALFALFA_FERMENTED CLOVER_FERMENTED",
    STRAW = "",
    DRYGRASS_WINDROW = "DRYALFALFA_WINDROW DRYCLOVER_WINDROW",
    MINERAL_FEED = ""
}

local function FeedingRobot_load(self, superFunc, linkNode, filename, onLoaded, target, args)
    local xmlFile = XMLFile.load("tempFeedingRobot", filename, FeedingRobot.xmlSchema)
    
    if xmlFile ~= nil then
        xmlFile:iterate("feedingRobot.unloadingSpots.unloadingSpot", function(_, spotKey)
            local currentFillTypes = xmlFile:getString(spotKey .. "#fillTypes") or ""
            
            for baseType, additions in pairs(FRConv.config) do
                if additions ~= "" and currentFillTypes:upper():find(baseType:upper()) then
                    
                    xmlFile:setString(spotKey .. "#fillTypes", (currentFillTypes .. " " .. additions):trim())
                    
                    local baleKey = spotKey .. ".baleTrigger"
                    if xmlFile:hasProperty(baleKey) then
                        local baleTypes = xmlFile:getString(baleKey .. "#fillTypes") or ""
                        xmlFile:setString(baleKey .. "#fillTypes", (baleTypes .. " " .. additions):trim())
                    end
                    
                    local convIdx = 0
                    while xmlFile:hasProperty(string.format("%s.fillTypeConversion(%d)", spotKey, convIdx)) do
                        convIdx = convIdx + 1
                    end
                    
                    for _, addType in ipairs(additions:split(" ")) do
                        local cleaned = addType:trim()
                        if cleaned ~= "" then
                            local cKey = string.format("%s.fillTypeConversion(%d)", spotKey, convIdx)
                            xmlFile:setString(cKey .. "#incomingFillType", cleaned)
                            xmlFile:setString(cKey .. "#outgoingFillType", baseType)
                            xmlFile:setFloat(cKey .. "#ratio", 1.0)
                            convIdx = convIdx + 1
                        end
                    end
                end
            end
        end)
        
        local oldXMLLoad = XMLFile.load
        XMLFile.load = function(name, fname, schema)
            if fname == filename then
                XMLFile.load = oldXMLLoad
                return xmlFile
            end
            return oldXMLLoad(name, fname, schema)
        end
    end

    return superFunc(self, linkNode, filename, onLoaded, target, args)
end

FeedingRobot.load = Utils.overwrittenFunction(FeedingRobot.load, FeedingRobot_load)