-- bunkerSiloExtension.lua
-- Version: 1.0.0.0
-- Author: Tidde23

if g_bunkerSiloExtension ~= nil then
    bunkerSiloExtension = g_bunkerSiloExtension
else
    bunkerSiloExtension = {}
    g_bunkerSiloExtension = bunkerSiloExtension
end
if bunkerSiloExtension._initialized then return end
bunkerSiloExtension._initialized = true


bunkerSiloExtension.switchPolicy = {
    liters = 1000  
}

function bunkerSiloExtension:getSwitchThreshold(_silo)
    local l = self.switchPolicy and self.switchPolicy.liters or 1000
    if l == nil or l < 1 then l = 1000 end
    return l
end

bunkerSiloExtension.luaMappings = {
    { baseFillType = "CHAFF", input = "CHAFF",         output = "SILAGE",                 extraFillTypes = { "CHAFF" } },
    { baseFillType = "CHAFF", input = "SILO_GRASS",    output = "GRASS_FERMENTED",        extraFillTypes = { "GRASS_WINDROW", "SILO_GRASS" } },
    { baseFillType = "CHAFF", input = "SILO_ALFALFA",  output = "ALFALFA_FERMENTED",      extraFillTypes = { "SILO_ALFALFA", "ALFALFA_WINDROW" } },
    { baseFillType = "CHAFF", input = "SILO_CLOVER",   output = "CLOVER_FERMENTED",       extraFillTypes = { "SILOCLOVER", "CLOVER_WINDROW" } },
}

local function ftIndex(name)
    if not name or name == "" then return nil end
    return g_fillTypeManager:getFillTypeIndexByName(string.upper(name))
end

local function accept(self, idx)
    if idx ~= nil then self.acceptedFillTypes[idx] = true end
end

local function siloTotalFillLevel(self)
    if self.fillLevel ~= nil then return self.fillLevel end
    local a = self.bunkerSiloArea
    if a == nil then return 0 end
    local sum = 0
    for ftIdx, ok in pairs(self.acceptedFillTypes or {}) do
        if ok then
            sum = sum + (DensityMapHeightUtil.getFillLevelAtArea(ftIdx, a.sx, a.sz, a.wx, a.wz, a.hx, a.hz) or 0)
        end
    end
    return sum
end

local function vehicleProbeFillType(vehicle)
    local s = vehicle and vehicle.spec_fillUnit
    if not s or not s.fillUnits then return nil end
    local bestType, bestLvl = nil, 0
    for _, fu in ipairs(s.fillUnits) do
        local lvl = fu.fillLevel or 0
        local ft  = fu.fillType
        if lvl > bestLvl and ft and ft ~= FillType.UNKNOWN then
            bestLvl, bestType = lvl, ft
        end
    end
    return bestType
end


bunkerSiloExtension.beforeSwitchLookup = {} 
bunkerSiloExtension.baseToExtras       = {} 

function bunkerSiloExtension:loadMap(_)
    self.beforeSwitchLookup = {}
    self.baseToExtras       = {}

    for _, m in ipairs(self.luaMappings) do
        local baseIdx = ftIndex(m.baseFillType)
        local inIdx   = ftIndex(m.input)
        local outIdx  = ftIndex(m.output)
        if baseIdx and inIdx and outIdx then
            local extras = self.baseToExtras[baseIdx]
            if extras == nil then
                extras = {}
                self.baseToExtras[baseIdx] = extras
            end
            for _, n in ipairs(m.extraFillTypes or {}) do
                local eIdx = ftIndex(n)
                if eIdx then
                    self.beforeSwitchLookup[eIdx] = { inIdx = inIdx, outIdx = outIdx }
                    extras[eIdx] = true
                end
            end
        end
    end
end
addModEventListener(bunkerSiloExtension)

function bunkerSiloExtension.bunkerSiloLoad(self, superFunc, components, xmlFile, key, i3dMappings)
    local ok = superFunc(self, components, xmlFile, key, i3dMappings)

    -- zusätzliche FillTypes akzeptieren, wenn Basis passt
    for baseIdx, extras in pairs(bunkerSiloExtension.baseToExtras) do
        if self.acceptedFillTypes[baseIdx] then
            for eIdx, _ in pairs(extras) do
                accept(self, eIdx)
            end
        end
    end

    if self.bunkerSiloArea ~= nil then
        g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)
    end

    self._bunkerSiloExtension_defaultInput  = self.inputFillType
    self._bunkerSiloExtension_defaultOutput = self.outputFillType
    self._bunkerSiloExtension_locked        = false

    return ok
end
BunkerSilo.load = Utils.overwrittenFunction(BunkerSilo.load, bunkerSiloExtension.bunkerSiloLoad)

local function _bunkerSiloExtension_trySwitch(self, vehicle)
    if self._bunkerSiloExtension_locked then return end

    local limit = bunkerSiloExtension:getSwitchThreshold(self)  
    local currentFill = self.fillLevel or 0
    if currentFill > limit then return end

    local trigFt = vehicleProbeFillType(vehicle)
    if not trigFt then return end

    local io = bunkerSiloExtension.beforeSwitchLookup[trigFt]
    if not io or not io.inIdx or not io.outIdx then return end
    if io.inIdx == self.inputFillType then return end

    if self.bunkerSiloArea ~= nil then
        g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
        g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, io.inIdx)
    end
    self.inputFillType  = io.inIdx
    self.outputFillType = io.outIdx
end

local _orig_bunkerSilo_interaction = BunkerSilo.interactionTriggerCallback
BunkerSilo.interactionTriggerCallback = function(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    local veh = g_currentMission.nodeToObject[otherId] or g_currentMission.nodeToObject[otherShapeId]
    if veh ~= nil then
        if onEnter or onStay then
            _bunkerSiloExtension_trySwitch(self, veh)
        end
    end

    if _orig_bunkerSilo_interaction ~= nil then
        return _orig_bunkerSilo_interaction(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    end
end

function bunkerSiloExtension.bunkerSiloUpdate(self, superFunc, dt)
    local limit = bunkerSiloExtension:getSwitchThreshold(self)


    if self._bunkerSiloExtension_locked and siloTotalFillLevel(self) <= 0 then
        if self.bunkerSiloArea ~= nil then
            g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
        end
        self.inputFillType  = self._bunkerSiloExtension_defaultInput  or self.inputFillType
        self.outputFillType = self._bunkerSiloExtension_defaultOutput or self.outputFillType
        if self.bunkerSiloArea ~= nil then
            g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)
        end
        self._bunkerSiloExtension_locked = false
    end

    if not self._bunkerSiloExtension_locked then
        if siloTotalFillLevel(self) > limit then
            self._bunkerSiloExtension_locked = true
        end
    end

    return superFunc(self, dt)
end
BunkerSilo.update = Utils.overwrittenFunction(BunkerSilo.update, bunkerSiloExtension.bunkerSiloUpdate)

if BunkerSilo.setIsFermenting ~= nil then
    local _orig_setIsFermenting = BunkerSilo.setIsFermenting
    function BunkerSilo:setIsFermenting(isFermenting)
        if isFermenting and self._bunkerSiloExtension_locked then
            if self.bunkerSiloArea ~= nil then
                g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
            end
            self.inputFillType  = self._bunkerSiloExtension_defaultInput or self.inputFillType
            self.outputFillType = self._bunkerSiloExtension_defaultOutput or self.outputFillType
            if self.bunkerSiloArea ~= nil then
                g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)
            end
            self._bunkerSiloExtension_locked = false
        end
        return _orig_setIsFermenting(self, isFermenting)
    end
end

if BunkerSilo.setCovered ~= nil then
    local _orig_setCovered = BunkerSilo.setCovered
    function BunkerSilo:setCovered(covered, noEventSend)
        if covered then
            if self._bunkerSiloExtension_locked then
                if self.bunkerSiloArea ~= nil then
                    g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
                end
                self.inputFillType  = self._bunkerSiloExtension_defaultInput or self.inputFillType
                self.outputFillType = self._bunkerSiloExtension_defaultOutput or self.outputFillType
                if self.bunkerSiloArea ~= nil then
                    g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)
                end
                self._bunkerSiloExtension_locked = false
            end
        else
            if self._bunkerSiloExtension_locked and siloTotalFillLevel(self) <= 0 then
                if self.bunkerSiloArea ~= nil then
                    g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
                end
                self.inputFillType  = self._bunkerSiloExtension_defaultInput or self.inputFillType
                self.outputFillType = self._bunkerSiloExtension_defaultOutput or self.outputFillType
                if self.bunkerSiloArea ~= nil then
                    g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)
                end
                self._bunkerSiloExtension_locked = false
            end
        end
        return _orig_setCovered(self, covered, noEventSend)
    end
end

function bunkerSiloExtension.registerSavegameXMLPaths(schema, basePath)
    schema:register(XMLValueType.STRING, basePath .. "#bunkerSiloExtensionInputFillType",  "bunkerSiloExtension: current input fillType name")
    schema:register(XMLValueType.STRING, basePath .. "#bunkerSiloExtensionOutputFillType", "bunkerSiloExtension: current output fillType name")
end
BunkerSilo.registerSavegameXMLPaths = Utils.appendedFunction(BunkerSilo.registerSavegameXMLPaths, bunkerSiloExtension.registerSavegameXMLPaths)

function bunkerSiloExtension.saveToXMLFile(self, xmlFile, key, usedModNames)
    if self.inputFillType ~= nil and self.outputFillType ~= nil then
        local inName  = g_fillTypeManager:getFillTypeByIndex(self.inputFillType).name
        local outName = g_fillTypeManager:getFillTypeByIndex(self.outputFillType).name
        xmlFile:setValue(key .. "#bunkerSiloExtensionInputFillType",  inName)
        xmlFile:setValue(key .. "#bunkerSiloExtensionOutputFillType", outName)
    end
end
BunkerSilo.saveToXMLFile = Utils.appendedFunction(BunkerSilo.saveToXMLFile, bunkerSiloExtension.saveToXMLFile)

function bunkerSiloExtension.loadFromXMLFile(self, superFunc, xmlFile, key)
    local ret = superFunc(self, xmlFile, key)
    local inName  = xmlFile:getValue(key .. "#bunkerSiloExtensionInputFillType")
    local outName = xmlFile:getValue(key .. "#bunkerSiloExtensionOutputFillType")
    if inName and outName then
        local inIdx  = ftIndex(inName)
        local outIdx = ftIndex(outName)
        if inIdx and outIdx then
            if self.bunkerSiloArea ~= nil then
                g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
            end
            self.inputFillType  = inIdx
            self.outputFillType = outIdx
            if self.bunkerSiloArea ~= nil then
                g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)
            end
        end
    end
    return ret
end
BunkerSilo.loadFromXMLFile = Utils.overwrittenFunction(BunkerSilo.loadFromXMLFile, bunkerSiloExtension.loadFromXMLFile)

function bunkerSiloExtension.writeStream(self, streamId, connection)
    if not connection:getIsServer() then
        streamWriteUIntN(streamId, self.inputFillType  or FillType.UNKNOWN, FillTypeManager.SEND_NUM_BITS)
        streamWriteUIntN(streamId, self.outputFillType or FillType.UNKNOWN, FillTypeManager.SEND_NUM_BITS)
    end
end
BunkerSilo.writeStream = Utils.appendedFunction(BunkerSilo.writeStream, bunkerSiloExtension.writeStream)

function bunkerSiloExtension.readStream(self, streamId, connection, objectId)
    if connection:getIsServer() then
        local inIdx  = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)
        local outIdx = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)
        if inIdx and outIdx then
            if self.bunkerSiloArea ~= nil then
                g_densityMapHeightManager:removeConvertingFillTypeAreas(self.bunkerSiloArea)
            end
            self.inputFillType  = inIdx
            self.outputFillType = outIdx
            if self.bunkerSiloArea ~= nil then
                g_densityMapHeightManager:setConvertingFillTypeAreas(self.bunkerSiloArea, self.acceptedFillTypes, self.inputFillType)
            end
        end
    end
end
BunkerSilo.readStream = Utils.appendedFunction(BunkerSilo.readStream, bunkerSiloExtension.readStream)
