
local modDirectory = g_currentModDirectory
local modName = g_currentModName

source(modDirectory .. "scr/bunkerSiloExtension.lua")
source(modDirectory .. "scr/FilltypeExtension.lua")
source(modDirectory .. "scr/BGA_FilltypeExtension.lua")
source(modDirectory .. "scr/FeedingRobot_Extension.lua")

ModLoader = {}
local fillTypesXmlPath = modDirectory .. "xml/fillTypes.xml"
local heightTypesXmlPath = modDirectory .. "xml/densityMapHeightTypes.xml"

function ModLoader:onLoadFillTypes(superFunc)
    superFunc(self)
    if fileExists(fillTypesXmlPath) then
        local xmlFile = XMLFile.load("ModFillTypes", fillTypesXmlPath, FillTypeManager.xmlSchema)
        if xmlFile ~= nil then
            self:loadFillTypes(xmlFile, modDirectory, false, modName)
            xmlFile:delete()
        end
    end
end

function ModLoader:registerHeightTypes()
    if fileExists(heightTypesXmlPath) then
        table.insert(g_densityMapHeightManager.modDensityHeightMapTypeFilenames, heightTypesXmlPath)
    end
end

FillTypeManager.loadDefaultTypes = Utils.overwrittenFunction(FillTypeManager.loadDefaultTypes, ModLoader.onLoadFillTypes)

ModLoader:registerHeightTypes()