
BMP_ExhaustPlusRegister = {}
BMP_ExhaustPlusRegister.modName = g_currentModName or "BMP_ExhaustPlus"
BMP_ExhaustPlusRegister.modDirectory = g_currentModDirectory or ""

local SPEC_NAME = "bmpExhaustPlus"
local SPEC_CLASS = "BMP_ExhaustPlusSpec"
local SPEC_FILE = Utils.getFilename("scripts/BMP_ExhaustPlusSpec.lua", BMP_ExhaustPlusRegister.modDirectory)

g_specializationManager:addSpecialization(SPEC_NAME, SPEC_CLASS, SPEC_FILE, nil)
print(string.format("[BMP_ExhaustPlus] Registered specialization '%s' (%s)", SPEC_NAME, SPEC_FILE))

local function inject()
    if g_vehicleTypeManager == nil or g_vehicleTypeManager.types == nil then
        print("[BMP_ExhaustPlus] g_vehicleTypeManager not ready yet")
        return
    end

    local added = 0
    for typeName, vehicleType in pairs(g_vehicleTypeManager.types) do
        if vehicleType ~= nil and vehicleType.specializations ~= nil then
            if SpecializationUtil.hasSpecialization(Motorized, vehicleType.specializations) then
                if not SpecializationUtil.hasSpecialization(BMP_ExhaustPlusSpec, vehicleType.specializations) then
                    g_vehicleTypeManager:addSpecialization(typeName, SPEC_NAME)
                    added = added + 1
                end
            end
        end
    end

    print(string.format("[BMP_ExhaustPlus] Injected into %d vehicle types (Motorized)", added))
end

inject()
