BMP_ExhaustPlusMpSyncEvent = BMP_ExhaustPlusMpSyncEvent or {}
local BMP_ExhaustPlusMpSyncEvent_mt = Class(BMP_ExhaustPlusMpSyncEvent, Event)

local EVENT_NAME = "BMP_ExhaustPlus.BMP_ExhaustPlusMpSyncEvent"

if BMP_ExhaustPlusMpSyncEvent.eventId == nil then
    InitEventClass(BMP_ExhaustPlusMpSyncEvent, EVENT_NAME)
end

local function ensureStreamId(streamId, connection)
    if type(streamId) ~= "number" and type(connection) == "number" then
        return connection, streamId
    end
    return streamId, connection
end


local function clamp(x, a, b)
    if x == nil then return a end
    if x < a then return a end
    if x > b then return b end
    return x
end

local function toQ01(x)
    x = clamp(x or 0, 0, 1)
    return math.floor(x * 255 + 0.5)
end

local function fromQ01(q)
    q = clamp(q or 0, 0, 255)
    return q / 255
end

function BMP_ExhaustPlusMpSyncEvent.emptyNew()
    local self = Event.new(BMP_ExhaustPlusMpSyncEvent_mt)
    return self
end

function BMP_ExhaustPlusMpSyncEvent.new(vehicle, load01, rpmN01)
    local self = BMP_ExhaustPlusMpSyncEvent.emptyNew()
    self.vehicle = vehicle
    self.loadQ = toQ01(load01)
    self.rpmQ  = toQ01(rpmN01)
    return self
end

function BMP_ExhaustPlusMpSyncEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)

    streamWriteUInt8(streamId, self.loadQ or 0)
    streamWriteUInt8(streamId, self.rpmQ or 0)
end

function BMP_ExhaustPlusMpSyncEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)

    self.loadQ = streamReadUInt8(streamId) or 0
    self.rpmQ  = streamReadUInt8(streamId) or 0

    self:run(connection)
end

function BMP_ExhaustPlusMpSyncEvent:run(connection)
    if self.vehicle == nil then
        return
    end

    local spec = self.vehicle.spec_bmpExhaustPlus
    if spec == nil then
        -- специализация могла не загрузиться на этой машине
        return
    end

    spec._mpLoad = fromQ01(self.loadQ)
    spec._mpRpmN = fromQ01(self.rpmQ)

    -- Если мы на сервере и получили от клиента -> разошлём всем остальным
    if g_server ~= nil then
        -- connection тут = клиент, от которого пришёл пакет
        -- исключаем его из рассылки (ему не нужно эхо)
        g_server:broadcastEvent(BMP_ExhaustPlusMpSyncEvent.new(self.vehicle, spec._mpLoad, spec._mpRpmN), false, connection, self.vehicle)
    end
end

function BMP_ExhaustPlusMpSyncEvent.sendEvent(vehicle, load01, rpmN01)
    if vehicle == nil then
        return
    end

    -- Клиент -> сервер
    if g_client ~= nil and g_server == nil then
        g_client:getServerConnection():sendEvent(BMP_ExhaustPlusMpSyncEvent.new(vehicle, load01, rpmN01))
        return
    end

    -- Сервер (если вдруг нужно принудительно разослать)
    if g_server ~= nil then
        g_server:broadcastEvent(BMP_ExhaustPlusMpSyncEvent.new(vehicle, load01, rpmN01), false, nil, vehicle)
    end
end
