--
-- DynamicHeaderSpeed
--
-- @autor	nilBrain @VertexDezign
-- @date	01.08.2022
-- Copyright (C) nilBrain, Confidential, All Rights Reserved.

DynamicHeaderSpeed = {};

--relative to km/h
DynamicHeaderSpeed.MIN_SPPED_FACTOR = 4;
DynamicHeaderSpeed.MAX_SPPED_FACTOR = 10;

local modName = DynamicHeaderSpeedRegister.MOD_NAME;


local supportetMods = {
	["FS25_ClaasLexion500.v600"] = "turnedOnAnimation_spikes",
	["FS25_ClaasLexion500.v660"] = "turnedOnAnimation_spikes",
	["FS25_ClaasLexion500.v750"] = "turnedOnAnimation_spikes",
	["FS25_ClaasLexion500.v900"] = "turnedOnAnimation_spikes",

	["FS25_Claas_Dominator_108SL.C510"] = "turnedOnAnimation_spikes",

	["FS25_claasMega.c600"] = "turnedOnAnimation_spikes"

}

function DynamicHeaderSpeed.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function DynamicHeaderSpeed.initSpecialization()
    local schemaSavegame = Vehicle.xmlSchemaSavegame
    local savegamePath = string.format("vehicles.vehicle(?).%s", modName);
    schemaSavegame:register(XMLValueType.INT, savegamePath .. ".dynamicHeaderSpeed#speedIndex", "Current header speed Index");
end;

function DynamicHeaderSpeed.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", DynamicHeaderSpeed);
	SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", DynamicHeaderSpeed);
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", DynamicHeaderSpeed);
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", DynamicHeaderSpeed);
	SpecializationUtil.registerEventListener(vehicleType, "onDraw", DynamicHeaderSpeed);
end;

function DynamicHeaderSpeed.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "isHeaderSpeedChangeAllow", DynamicHeaderSpeed.isHeaderSpeedChangeAllow);
	SpecializationUtil.registerFunction(vehicleType, "getHeaderSpeed", DynamicHeaderSpeed.getHeaderSpeed);
	SpecializationUtil.registerFunction(vehicleType, "setHeaderSpeedScale", DynamicHeaderSpeed.setHeaderSpeedScale);
	SpecializationUtil.registerFunction(vehicleType, "actionEventHeaderSpeedValue", DynamicHeaderSpeed.actionEventHeaderSpeedValue);
end;

function DynamicHeaderSpeed:onLoad(savegame)
	self.spec_dynamicHeaderSpeed = self[string.format("spec_%s.dynamicHeaderSpeed", modName)];
	local spec = self.spec_dynamicHeaderSpeed;

	spec.isActive = self:isHeaderSpeedChangeAllow();
	spec.lastSpeedValue = 0.4;

	if self.isClient then

		local nameSpace = self.customEnvironment == nil and self.configFileNameClean or self.customEnvironment .. "." .. self.configFileNameClean
		local animName = supportetMods[nameSpace]

		local specCutter = self.spec_cutter;
		local newSpeedFunc = function()
			local speed = math.clamp(self:getLastSpeed(true) / self:getRawSpeedLimit(), DynamicHeaderSpeed.MIN_SPPED_FACTOR / 10, DynamicHeaderSpeed.MAX_SPPED_FACTOR / 10) * spec.headerSpeedScale;

			if self:getIsLowered(true) then
				spec.lastSpeedValue = speed;
			else
				speed = spec.lastSpeedValue;
			end;
			return speed;
		end;

		local hasAnimationFound = false;
		if specCutter ~= nil and spec.isActive then
			if specCutter.animationNodes ~= nil then
				for _, animation in ipairs(specCutter.animationNodes) do
					for node in pairs(animation.nodes) do
						if node ~= nil then
							if getName(node):lower():find("reel") or getName(node):lower():find("spike") then
								animation.speedFunc = newSpeedFunc;
								hasAnimationFound = true;
								break;
							end;
						end;
					end;
				end;
			end;
		end;

		local specTurnOn = self.spec_turnOnVehicle;
		if specTurnOn ~= nil then
			for i = 1, #specTurnOn.turnedOnAnimations do
				local turnedOnAnimation = specTurnOn.turnedOnAnimations[i];
				if turnedOnAnimation.name:lower():find("reel") or  turnedOnAnimation.name:lower():find("spike") then
					hasAnimationFound = true;
					break;
				end;
			end;
		end;


		if animName ~= nil then
			local specAnim = self.spec_animatedVehicle
			if specAnim ~= nil and specAnim.animations[animName] ~= nil then
				hasAnimationFound = true
			end
		end

		spec.isActive = spec.isActive and hasAnimationFound;
	end;

	if spec.isActive then
		spec.headerSpeedScale = g_dynamicHeaderSpeedSetting:getSpeedFromIndex(g_dynamicHeaderSpeedSetting:getSpeedIndex());

		if savegame ~= nil then
			local savegameKey = string.format("%s.%s.dynamicHeaderSpeed", savegame.key, modName);

			local index = savegame.xmlFile:getValue(savegameKey .. "#speedIndex");
			if index ~= nil then
				spec.headerSpeedScale = g_dynamicHeaderSpeedSetting:getSpeedFromIndex(index);
			end;
		end;
	else
		SpecializationUtil.removeEventListener(self, "onPostLoad", DynamicHeaderSpeed);
		SpecializationUtil.removeEventListener(self, "onRegisterActionEvents", DynamicHeaderSpeed);
		SpecializationUtil.removeEventListener(self, "onUpdate", DynamicHeaderSpeed);
		SpecializationUtil.removeEventListener(self, "onDraw", DynamicHeaderSpeed);
	end;
end;


function DynamicHeaderSpeed:onPostLoad()
	local spec = self.spec_dynamicHeaderSpeed;
end;

function DynamicHeaderSpeed:saveToXMLFile(xmlFile, key, usedModNames)
    local spec = self.spec_dynamicHeaderSpeed
	local speedIndex = g_dynamicHeaderSpeedSetting:getIndexFromSpeed(spec.headerSpeedScale);
	xmlFile:setValue(key .. "#speedIndex", speedIndex);
end

function DynamicHeaderSpeed:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
        if isActiveForInput then
			local spec = self.spec_dynamicHeaderSpeed;
            local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.DHS_AXIS_HEADERSPEED, self, DynamicHeaderSpeed.actionEventHeaderSpeedValue, false, true, false, true, nil);
			g_inputBinding:setActionEventTextVisibility(actionEventId, false);
		end;
	end;
end;

function DynamicHeaderSpeed:onUpdate()
	if self.isClient then

		local spec = self.spec_dynamicHeaderSpeed;
		local specTurnOn = self.spec_turnOnVehicle;

		spec.headerSpeedScale = 1

		if specTurnOn ~= nil then
			for i = 1, #specTurnOn.turnedOnAnimations do
				local nameSpace = self.customEnvironment == nil and self.configFileNameClean or self.customEnvironment .. "." .. self.configFileNameClean
				local animName = supportetMods[nameSpace]
				local turnedOnAnimation = specTurnOn.turnedOnAnimations[i];
				local isTurnedOn = self:getIsTurnedOnAnimationActive(turnedOnAnimation);

				if (turnedOnAnimation.name:lower():find("reel") or animName ~= nil and animName == turnedOnAnimation.name) and isTurnedOn then

					local speed = math.clamp(self:getLastSpeed(true) / self:getRawSpeedLimit(), DynamicHeaderSpeed.MIN_SPPED_FACTOR / 10, DynamicHeaderSpeed.MAX_SPPED_FACTOR / 10) * spec.headerSpeedScale;

					if self:getIsLowered(true) then
						spec.lastSpeedValue = speed;
					else
						speed = spec.lastSpeedValue;
					end;

					self:setAnimationSpeed(turnedOnAnimation.name, turnedOnAnimation.currentSpeed*turnedOnAnimation.speedScale * speed);
				end;
			end;
		end;
	end;
end;

function DynamicHeaderSpeed:onDraw(isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	if isSelected then
		local text = string.format("[%d%%] %s", self:getHeaderSpeed()*100, g_i18n:getText("action_changeHeaderSpeedLevel"));
		g_currentMission:addExtraPrintText(text);
	end;
end;

function DynamicHeaderSpeed:isHeaderSpeedChangeAllow()
	local isAllowed = false;
	local supportedFruitTypes = g_fruitTypeManager:getFruitTypeIndicesByCategoryNames("grainHeader");

	local supportedFillType = {};
    for _, sFruitTypeIndex in ipairs(supportedFruitTypes) do
        supportedFillType[sFruitTypeIndex] = true;
    end;

	if self.spec_cutter ~= nil and self.spec_cutter.fruitTypeIndices ~= nil then
		for _, fruitTypeIndex in ipairs(self.spec_cutter.fruitTypeIndices) do
			if supportedFillType[fruitTypeIndex] then
				isAllowed = true;
				break;
			end;
		end;
	end;

	return isAllowed;
end;

function DynamicHeaderSpeed:getHeaderSpeed()
	return self.spec_dynamicHeaderSpeed.headerSpeedScale;
end;

function DynamicHeaderSpeed:setHeaderSpeedScale(speedIndex, noEventSend)

	if speedIndex ~= nil then
		local spec = self.spec_dynamicHeaderSpeed;

		if (noEventSend == nil or noEventSend == false) and g_server == nil and g_client ~= nil then
			g_client:getServerConnection():sendEvent(VehicleSettingsChangeEvent.new(self, speedIndex));
		end

		spec.headerSpeedScale = g_dynamicHeaderSpeedSetting:getSpeedFromIndex(speedIndex);
	end;
end;


function DynamicHeaderSpeed:actionEventHeaderSpeedValue(actionName, inputValue, callbackState, isAnalog)
	local spec = self.spec_dynamicHeaderSpeed;
	local value = g_dynamicHeaderSpeedSetting:getIndexFromSpeed(spec.headerSpeedScale) + inputValue;

	self:setHeaderSpeedScale(g_dynamicHeaderSpeedSetting:getValidSpeedIndex(value));
end;