--[[
BasegameAdjustments

Specialization to adjust some things in the base game

Author: 	Ifko[nator]
Date: 		05.01.2025
Version:	1.0

History:	v1.0 @05.01.2025 - initial implemation in FS 25
]]

BasegameAdjustments = {};

BasegameAdjustments.COLOR = {
	STATUS_BAR_BACKGROUND = {0.00439, 0.00478, 0.00368, 0.9},
	STATUS_BAR_GOOD = {0.2384, 0.4621, 0.0015, 1},
	STATUS_BAR_ALMOST_GOOD = {0.6, 0.5, 0, 1},
	STATUS_BAR_BETTER = {1, 0.2, 0, 1},
	STATUS_BAR_BAD = {0.8069, 0.0097, 0.0097, 1}
};

function BasegameAdjustments:mixerWagonDraw(superFunc, leftPosX, rightPosX, posY)
    local backGroundColor = BasegameAdjustments.COLOR.STATUS_BAR_BACKGROUND;
	
	self.backgroundTop:setPosition(rightPosX, posY - self.backgroundTop.height);
	self.backgroundScale:setPosition(rightPosX, self.backgroundTop.y - self.backgroundScale.height);
	self.backgroundBottom:setPosition(rightPosX, self.backgroundScale.y - self.backgroundBottom.height);
	self.backgroundTop:render();
	self.backgroundScale:render();
	self.backgroundBottom:render();

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextColor(1, 1, 1, 1);
	setTextBold(true);
	
	local textWidth = self.backgroundTop.width - 2 * self.titleOffsetX;
	local title = Utils.limitTextToWidth(self.title, self.titleSize, textWidth, false, "...");
	
	renderText(rightPosX + self.titleOffsetX, posY + self.titleOffsetY, self.titleSize, title);
	setTextAlignment(RenderText.ALIGN_RIGHT);
	
	local totalFillLevel = 0;
	
	if self.vehicle:getFillUnitFillLevel(self.mixerWagon.fillUnitIndex) > 0 then
		for fillTypeNumber, mixerWagonFillType in ipairs(self.mixerWagon.mixerWagonFillTypes) do
			totalFillLevel = totalFillLevel + mixerWagonFillType.fillLevel;

			self.fillTypeStatus[fillTypeNumber].fillLevel = mixerWagonFillType.fillLevel;
		end;
	end;

	local posY = posY - self.offsetTop
	local leftPosX = rightPosX + self.backgroundTop.width + self.textOffsetX
	local specMixerWagon = self.mixerWagon;
	local failedOutputFillType = specMixerWagon.failedOutputFillType;
	local needsMixingTime = Utils.getNoNil(specMixerWagon.requiredMixingTime, 0) > 0;

	if specMixerWagon.hasStrawLoaded then
		failedOutputFillType = specMixerWagon.failedOutputFillTypeStraw;
	end;
	
	for _, fillTypeDisplay in ipairs(self.fillTypeStatus) do
		posY = posY - self.heightPerFillType;
		
		fillTypeDisplay.icon:setPosition(rightPosX + self.iconOffsetX, posY + self.iconOffsetY);
		fillTypeDisplay.icon:render();
		
		self.bar:setMiddlePart(nil, self.middlePartMaxWidth, nil);
		self.bar:setColor(unpack(backGroundColor));
		self.bar:setPosition(rightPosX + self.barOffsetX, posY + self.barOffsetY);
		self.bar:render();

		local percentage = self.vehicle:getFillUnitFillLevel(self.mixerWagon.fillUnitIndex) <= 0 and 0 or fillTypeDisplay.fillLevel / totalFillLevel;
		local barPartsWidth = self.barMaxWidth * (fillTypeDisplay.maxPercentage - fillTypeDisplay.minPercentage) - self.barPartsWidth;
		local barOffsetX = self.barMaxWidth * fillTypeDisplay.minPercentage;
		local barColor = BasegameAdjustments.COLOR.STATUS_BAR_BAD;

		if fillTypeDisplay.fillLevel > 0 and (self.vehicle:getFillUnitFillType(self.mixerWagon.fillUnitIndex) ~= failedOutputFillType or fillTypeDisplay.minPercentage <= percentage and percentage <= fillTypeDisplay.maxPercentage) then
			barColor = BasegameAdjustments.COLOR.STATUS_BAR_GOOD;
		end;

		self.bar:setColor(unpack(barColor));
		self.bar:setMiddlePart(nil, barPartsWidth, nil);
		self.bar:setPosition(rightPosX + self.barOffsetX + barOffsetX, nil);
		self.bar:render();
		self.marker:setPosition(rightPosX + self.barOffsetX + self.barMaxWidth * percentage - self.marker.width * 0.5, self.bar.y - (self.marker.height - self.barPartHeight) * 0.5);
		self.marker:render();
		
		renderText(leftPosX, posY + self.textOffsetY, self.textSize, string.format("%d%%", percentage * 100));
	end;

	if needsMixingTime then
		local uiScale = g_gameSettings:getValue("uiScale");
		local width, height = getNormalizedScreenValues(330 * uiScale, 160 * uiScale);

		self.backgroundScale:setDimension(width, height);

		local function getFormattedTime()
            local function getExtraZero(time, skip)    
                if time < 10 and not skip then
                    time = "0" .. time;
                end;
				
                return tostring(time);
            end;
			
			local neededTime = math.clamp(math.ceil(specMixerWagon.requiredMixingTime - (specMixerWagon.currentMixingTime / 1000)), 0, specMixerWagon.requiredMixingTime);

            local hours = getExtraZero(math.floor(neededTime / 3600), true);
            local minutes = getExtraZero(math.floor((neededTime % 3600) / 60), hours == "0");
            local seconds = getExtraZero(math.floor(neededTime % 60), minutes == "0");

			local text_hours = g_i18n:getText("text_hours", EnhancedMixerWagons.currentModName);
			local text_minutes = g_i18n:getText("text_minutes", EnhancedMixerWagons.currentModName);
			local text_seconds = g_i18n:getText("text_seconds", EnhancedMixerWagons.currentModName);

			if hours == "1" then
				text_hours = text_hours:sub(1, text_hours:len() - 1);
			end;

			if minutes == "01" or minutes == "1" then
				text_minutes = text_minutes:sub(1, text_minutes:len() - 1);
			end;

			if seconds == "01" or seconds == "1" then
				text_seconds = text_seconds:sub(1, text_seconds:len() - 1);
			end;
        
            local formatedTime = hours .. " " .. text_hours .. " : " .. minutes .. " " .. text_minutes .. " : " .. seconds .. " " .. text_seconds;

			if hours == "0" then
				formatedTime = minutes .. " " .. text_minutes .. " : " .. seconds .. " " .. text_seconds;

				if minutes == "0" then
					formatedTime = seconds .. " " .. text_seconds;
				end;
			end;

			return formatedTime;
        end;
		
		barY = posY - self.textOffsetY * 2;

		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(true);

        renderText(rightPosX + self.titleOffsetX, barY, self.titleSize, g_i18n:getText("NEEDED_MIXING_TIME", EnhancedMixerWagons.currentModName) .. " " .. getFormattedTime());
        
		setTextBold(false);
		setTextAlignment(RenderText.ALIGN_RIGHT);
		
        if specMixerWagon.timeOverlay ~= nil then
            specMixerWagon.timeOverlay:setPosition(rightPosX + self.iconOffsetX, barY - self.titleSize * 2.5);
            specMixerWagon.timeOverlay:render();
        end;

		local mixingTimePercentage = specMixerWagon.mixingTimePercentage;

		renderText(leftPosX, barY - self.titleSize * 1.8, self.textSize, ("%d%%"):format(mixingTimePercentage * 100));

		local width, height = getNormalizedScreenValues(3, 6);
		
		specMixerWagon.statusBar:setLeftPart(nil, width, height);
		specMixerWagon.statusBar:setMiddlePart(nil, self.middlePartMaxWidth, height);
		specMixerWagon.statusBar:setRightPart(nil, width, height);

		specMixerWagon.statusBar:setColor(unpack(backGroundColor));
		specMixerWagon.statusBar:setPosition(rightPosX + self.barOffsetX, barY - self.titleSize * 1.7);
		specMixerWagon.statusBar:render();

		local barPartsWidth = self.barMaxWidth * mixingTimePercentage;
		
		if mixingTimePercentage == 1 then
            specMixerWagon.statusBar:setColor(unpack(BasegameAdjustments.COLOR.STATUS_BAR_GOOD));
        elseif mixingTimePercentage > 0.7 and mixingTimePercentage < 1 then
            specMixerWagon.statusBar:setColor(unpack(BasegameAdjustments.COLOR.STATUS_BAR_ALMOST_GOOD));
        elseif mixingTimePercentage > 0.35 and mixingTimePercentage < 0.7 then
            specMixerWagon.statusBar:setColor(unpack(BasegameAdjustments.COLOR.STATUS_BAR_BETTER));
        else
            specMixerWagon.statusBar:setColor(unpack(BasegameAdjustments.COLOR.STATUS_BAR_BAD));
        end;

		specMixerWagon.statusBar:setLeftPart(nil, width * mixingTimePercentage, height);
		specMixerWagon.statusBar:setMiddlePart(nil, barPartsWidth, nil);
		specMixerWagon.statusBar:setRightPart(nil, width * mixingTimePercentage, height);
		
		specMixerWagon.statusBar:render();
    end;

	setTextBold(false);

	return self.backgroundBottom.y;
end;

MixerWagonHUDExtension.draw = Utils.overwrittenFunction(MixerWagonHUDExtension.draw, BasegameAdjustments.mixerWagonDraw);

function BasegameAdjustments:getFillTypesFromXML(superFunc, fillTypes, usedFillTypes, xmlFile, key)
	local fillTypeNameStr = xmlFile:getValue(key);

	if fillTypeNameStr == nil then
		Logging.xmlError(xmlFile, "Missing fillTypes for ingredient '%s'", key);

		return false;
	end;

	if fillTypeNameStr:upper():find("GRASS") and not fillTypeNameStr:upper():find("DRY") then
		--## add forage failed and forage straw failed to food group grass
		
		fillTypeNameStr = fillTypeNameStr .. " FORAGE_FAILED FORAGE_STRAW_FAILED";
	end;
	
	local fillTypeNames = fillTypeNameStr:split(" ");

	for _, fillTypeName in pairs(fillTypeNames) do
		local fillTypeIndex = g_fillTypeManager:getFillTypeIndexByName(fillTypeName);

		if fillTypeIndex ~= nil then
			if usedFillTypes[fillTypeIndex] == nil then
				table.addElement(fillTypes, fillTypeIndex);
			else
				Logging.xmlWarning(xmlFile, "FillType '%s' already used in other ingredient", fillTypeName);
			end;
		else
			Logging.xmlWarning(xmlFile, "FillType '%s' not defined. Ignoring it", fillTypeName);
		end;
	end;

	if #fillTypes == 0 then
		Logging.xmlError(xmlFile, "No fillTypes defined - '%s'", key);

		return false;
	end;

	return true;
end;

AnimalFoodSystem.getFillTypesFromXML = Utils.overwrittenFunction(AnimalFoodSystem.getFillTypesFromXML, BasegameAdjustments.getFillTypesFromXML);